<?php

namespace App\Filters;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\Filters\FilterInterface;

class UserAccessFilter implements FilterInterface
{
    public function before(RequestInterface $request, $arguments = null)
    {
        $session = session();
        // Check if the user is staff and has Specific access
        if ($session->get('role') === 'STAFF' && $session->get('access_pages') === 'Specific') {
            $allowedPages = $session->get('specific_pages') ?? [];

             $pageName = $arguments[0] ?? null;

            zzif (!in_array($pageName, $allowedPages)) {
                // Block access if the page is not allowed
                return redirect()->to(base_url('/access-denied'))->with('error', 'You do not have access to this page.');
            }
        }
    }

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        // Optional: Additional processing after the controller method
    }
}
