<?php

if (! function_exists('amountInWords')) {

    function amountInWords($number)
    {
        $number = round((float)$number, 2);

        $no = floor($number);
        $point = round(($number - $no) * 100);

        $words = [
            0 => '', 1 => 'One', 2 => 'Two', 3 => 'Three', 4 => 'Four',
            5 => 'Five', 6 => 'Six', 7 => 'Seven', 8 => 'Eight', 9 => 'Nine',
            10 => 'Ten', 11 => 'Eleven', 12 => 'Twelve', 13 => 'Thirteen',
            14 => 'Fourteen', 15 => 'Fifteen', 16 => 'Sixteen',
            17 => 'Seventeen', 18 => 'Eighteen', 19 => 'Nineteen',
            20 => 'Twenty', 30 => 'Thirty', 40 => 'Forty',
            50 => 'Fifty', 60 => 'Sixty', 70 => 'Seventy',
            80 => 'Eighty', 90 => 'Ninety'
        ];

        $digits = ['', 'Hundred', 'Thousand', 'Lakh', 'Crore'];
        $result = [];

        $i = 0;
        while ($no > 0) {
            $divider = ($i == 1) ? 10 : 100;
            $numberPart = $no % $divider;
            $no = (int)($no / $divider);

            if ($numberPart) {
                $text = '';

                if ($numberPart < 21) {
                    $text = $words[$numberPart];
                } else {
                    $text = $words[(int)($numberPart / 10) * 10] . ' ' . $words[$numberPart % 10];
                }

                if (!empty($digits[$i])) {
                    $text .= ' ' . $digits[$i];
                }

                array_unshift($result, $text);
            }

            $i++;
        }

        $rupees = implode(' ', $result);
        $paise  = '';

        if ($point > 0) {
            $paise = ' and ' .
                $words[(int)($point / 10) * 10] . ' ' .
                $words[$point % 10] . ' Paise';
        }

        return trim($rupees) . ' Rupees' . $paise . ' Only';
    }
}
