<?php
namespace App\Libraries;

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

class Mailer
{
    protected $mail;

    public function __construct()
    {
        $this->mail = new PHPMailer(true);

        // 🔹 SMTP Config (use main domain mail server, not subdomain)
        $this->mail->isSMTP();
        $this->mail->Host       = 'mail.eservicez.in';       // always main mail server
        $this->mail->SMTPAuth   = true;
        $this->mail->Username   = 'info@harshainfotech.biz';       // full email
        $this->mail->Password   = ';VFFSkpRsV3+';           // mailbox password (reset in cPanel)
        $this->mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;  // TLS encryption
        $this->mail->Port       = 587;                             // 587 for TLS, or 465 with SSL

        $this->mail->CharSet = 'UTF-8';
        $this->mail->isHTML(true);
    }

    public function sendMail(
        $to,
        $subject,
        $htmlBody,
        $plainBody = '',
        $from = 'info@harshainfotech.biz',
        $fromName = 'Sky Engineering',
        $attachment = null
    ) {
        try {
            $this->mail->clearAddresses();
            $this->mail->clearAttachments();

            // From
            $this->mail->setFrom($from, $fromName);

            // To
            if (is_array($to)) {
                foreach ($to as $addr) {
                    $this->mail->addAddress($addr);
                }
            } else {
                $this->mail->addAddress($to);
            }

            // Subject & Body
            $this->mail->Subject = $subject;
            $this->mail->Body    = $htmlBody;
            $this->mail->AltBody = $plainBody ?: strip_tags($htmlBody);

            // Optional attachment
            if ($attachment && $attachment->isValid()) {
                $this->mail->addAttachment($attachment->getTempName(), $attachment->getClientName());
            }

            return $this->mail->send();
        } catch (Exception $e) {
            log_message('error', 'Mailer Error: ' . $this->mail->ErrorInfo);
            return false;
        }
    }

    public function getError()
    {
        return $this->mail->ErrorInfo;
    }
}
