<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	
	
	<link rel="preconnect" href="https://fonts.gstatic.com">
	
	<?php
	$favicon = [
		'href'  => 'public/img/icons/icon-48x48.png',
		'rel'   => 'shortcut icon',
		'type'  => 'image/png',		
	];
	echo link_tag($favicon);
	?>
	

	<title><?=$this->renderSection("pageTitle")?></title>
	<!-- Theme Style CSS -->
	<?=link_tag('public/css/app.css')?>
	<?=link_tag('public/css/light.css')?>
	<?=link_tag('public/css/parsley.css')?>
	<?=link_tag('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600&display=swap')?>	
	<?=link_tag('https://cdn.jsdelivr.net/npm/sweetalert2@7.12.15/dist/sweetalert2.min.css')?>	
	<link rel="stylesheet"
      href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"
      crossorigin="anonymous">

	
	<?=$this->renderSection('styles')?>



	<script type="text/javascript">
		var base_url = '<?=base_url()?>';
	</script>

</head>

<body>
	<div class="wrapper">
		<!--sidebar wrapper -->
		<?=$this->include('layouts/inc/nav.php')?>
		<!--end sidebar wrapper -->
		

		<div class="main">
			<!--start header -->
			<?=$this->include('layouts/inc/header.php')?>
			<!--end header -->
					
			<!--start page wrapper -->
			<?=$this->renderSection('body')?>
			<!--end page wrapper -->

			<!--footer start-->
			 <?=$this->include('layouts/inc/footer.php')?>
			 <!--end footer--> 
			
		</div>
	</div>

	<!-- script link start -->
	<?=script_tag('public/js/jquery.min.js')?>
	<?=script_tag('public/js/app.js')?>	
	<?=script_tag('public/js/general.js')?>	
	
	<!-- SELECT2 JS (GLOBAL, SAFE) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>

	<?=script_tag('https://cdn.jsdelivr.net/npm/sweetalert2@7.12.15/dist/sweetalert2.all.min.js')?>	
	
	
	<?=$this->renderSection('scripts')?>

</body>

</html>