function confirmSave($form, $mode = 1) {
  if ($mode == 2) {
    $title = "Are you sure you want to update this record(s)?";
    $text = "Update Confirmation!";
    $btntext = "Yes, Update it!";
  } else {
    $title = "Are you sure you want to save this record(s)?";
    $text = "Save Confirmation!";
    $btntext = "Yes, Save it!";
  }

  swal({
    title: $title,
    text: $text,
    icon: "warning",
    buttons: {
      cancel: true,
      confirm: {
        text: $btntext,
        value: true,
        visible: true,
        className: "",
        closeModal: false,
      },
    },
    dangerMode: true,
  }).then((willDelete) => {
    if (willDelete) {
      var posting = $.post(
        $form.attr("action"),
        $form.serialize(),
        function (result) {
          if (result.success == true) {
            setTimeout(function () {
              swal({
                title: result.status,
                text: result.status_text,
                icon: result.status_icon,
                button: "Done",
              }).then((ok) => {
                if (result.redirect_url)
                  window.location.href = result.redirect_url;
                else window.location.reload();
              });
            }, 500);
          } else if (result.success == false) {
            setTimeout(function () {
              swal({
                title: "Error!",
                text: result.status_text,
                type: "error",
              });
            }, 500);
            status = "false";
          }
        },
        "json"
      );
      posting.fail(function (jqXHR, textStatus, errorThrown) {
        swal.close();
        OnError(jqXHR, textStatus, errorThrown);
      });
    } else {
      return;
    }
  });
}

function confirmDelete() {
  var result = confirm(
    "Are you sure you want to delete selected all record(s)?"
  );
  if (result) {
    return true;
  } else {
    return false;
  }
}

function confirmBulkDelete($form) {
  // if($('.checkbox:checked').length > 0){
  // 	var result = confirm("Are you sure to delete selected rows?");
  // 	if(result){
  // 		return true;
  // 	}else{
  // 		return false;
  // 	}
  // }else{
  // 	swal('Select at least 1 record to delete.');
  // 	return false;
  // }

  if ($(".checkbox:checked").length > 0) {
    swal({
      title: "Are you sure you want to delete this record(s)?",
      text: "Delete Confirmation!",
      icon: "warning",
      buttons: true,
      dangerMode: true,
    }).then((willDelete) => {
      if (willDelete) {
        var posting = $.post(
          $form.attr("action"),
          $form.serialize(),
          function (result) {
            if (result.success == true) {
              setTimeout(function () {
                swal({
                  title: result.status,
                  text: result.status_text,
                  icon: result.status_icon,
                  button: "Done",
                }).then((ok) => {
                  if (result.redirect_url)
                    window.location.href = result.redirect_url;
                });
              }, 500);
            } else if (result.success == false) {
              setTimeout(function () {
                swal({
                  title: "Error!",
                  text: result.status_text,
                  type: "error",
                });
              }, 500);
              status = "false";
            }
          },
          "json"
        );
        posting.fail(function (jqXHR, textStatus, errorThrown) {
          swal.close();
          OnError(jqXHR, textStatus, errorThrown);
        });
      } else {
        return;
      }
    });
  } else {
    swal("Select at least 1 record to delete.");
    return false;
  }
}

function OnError(xhr, errorType, exception) {
  var responseText;
  $("#dialog").html("");
  try {
    responseText = jQuery.parseJSON(xhr.responseText);
    $("#dialog").append(
      "<div><b>" + errorType + " " + exception + "</b></div>"
    );
    $("#dialog").append(
      "<div><u>Exception</u>:<br /><br />" +
        responseText.ExceptionType +
        "</div>"
    );
    $("#dialog").append(
      "<div><u>StackTrace</u>:<br /><br />" + responseText.StackTrace + "</div>"
    );
    $("#dialog").append(
      "<div><u>Message</u>:<br /><br />" + responseText.Message + "</div>"
    );
  } catch (e) {
    responseText = xhr.responseText;
    $("#dialog").html(responseText);
  }
  if (responseText != null) {
    $("#dialog").dialog({
      title: "Error Details",
      width: 700,
      height: 400,
      buttons: {
        Close: function () {
          $(this).dialog("close");
        },
      },
    });
  }
}
